/*
 * Decompiled with CFR 0.152.
 */
package org.antarcticgardens.esl.transaction;

import java.util.HashMap;
import java.util.Map;
import org.antarcticgardens.esl.transaction.TransactionContext;
import org.antarcticgardens.esl.transaction.TransactionResult;

public abstract class SnapshotParticipant<T> {
    private final Map<Integer, T> snapshots = new HashMap<Integer, T>();

    public abstract T createSnapshot();

    public abstract void restoreSnapshot(T var1);

    protected void onFinalCommit() {
    }

    protected void updateSnapshots(TransactionContext context) {
        if (!this.snapshots.containsKey(context.getNestingDepth())) {
            context.addCloseCallback(this::onClose);
            this.snapshots.put(context.getNestingDepth(), this.createSnapshot());
        }
    }

    private void onClose(TransactionContext context, TransactionResult result) {
        T snapshot = this.snapshots.remove(context.getNestingDepth());
        if (result.equals((Object)TransactionResult.ABORTED)) {
            this.restoreSnapshot(snapshot);
        } else if (context.getNestingDepth() > 0) {
            int parent = context.getNestingDepth() - 1;
            if (!this.snapshots.containsKey(parent)) {
                this.snapshots.put(parent, snapshot);
                context.getOpenTransaction(parent).addCloseCallback(this::onClose);
            }
        } else {
            context.addOuterCloseCallback(r -> this.onFinalCommit());
        }
    }
}

